<?php
require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

// Require authentication
requireAuth();

$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

// NOTE: This template appears to contain a destructive operation.
// Removing accidental delete-all behavior; render orders list instead.
$business_id = $current_business['business_id'];
$orders = all_rows("SELECT * FROM orders WHERE business_id = ? ORDER BY created_at DESC LIMIT 200", [$business_id]);
?>

<style>
  body {
    background-image: url("<?php echo BASE_URL; ?>/public/background.jpg");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
  }
  .container{
    background: rgba(255, 255, 255, 0.88);
    border-radius: 16px;
    padding: 1rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, .15);
    backdrop-filter: blur(2px);
  }
</style>

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Orders</h3>
  <div>
    <a class="btn btn-primary" href="<?= BASE_URL ?>/public?r=order/new">New Order</a>
    <a class="btn btn-danger"
       href="<?= BASE_URL ?>/public/?r=orders/delete_all"
       onclick="return confirm('Are you sure you want to delete all orders?');">
       Delete All Orders
    </a>
  </div>
</div>


<table class="table table-striped">
  <thead><tr><th>ID</th><th>Date</th><th>Table</th><th>Status</th><th>Total</th><th></th></tr></thead>
  <tbody>
    <?php foreach($orders as $o): ?>
      <tr>
        <td><?= e($o['id']) ?></td>
        <td><?= e($o['created_at']) ?></td>
        <td><?= e($o['table_no']) ?></td>
        <td><?= e($o['status']) ?></td>
        <td>₹ <?= e(number_format($o['total'],2)) ?></td>
        <td><a class="btn btn-sm btn-outline-primary" href="<?= BASE_URL ?>/public/?r=orders/show&id=<?= e($o['id']) ?>">Open</a></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
