<?php

require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

// Require authentication
requireAuth();

// Get current business
$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

// Log activity
logActivity('order_show_view', 'Viewed order details');

$cats  = all_rows("SELECT * FROM categories WHERE is_active=1 AND business_id = ? ORDER BY name", [$current_business['business_id']]);
$items = all_rows("SELECT * FROM items WHERE is_active=1 AND business_id = ? ORDER BY name", [$current_business['business_id']]);

$order_id = $_GET['id'] ?? 0;
$order = one("SELECT * FROM orders WHERE id=? AND business_id = ?", [$order_id, $current_business['business_id']]);

if (!$order) {
    echo "<div class='alert alert-danger'>❌ Order not found.</div>";
    return; // stop execution
}

$ois   = all_rows("SELECT * FROM order_items WHERE order_id=? ORDER BY id", [$order_id]);

// Use DB values
$subtotal    = (float)$order['subtotal'];
$discount    = (float)$order['discount'];
$tax         = (float)$order['tax'];
$total       = (float)$order['total'];
$gst_enabled = (int)($order['gst_enabled'] ?? 1);
?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<style>
  body {
    background-image: url("<?php echo BASE_URL; ?>/public/background.jpg");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
  }
  .container{
    background: rgba(255, 255, 255, 0.88);
    border-radius: 16px;
    padding: 1rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, .15);
    backdrop-filter: blur(2px);
  }
</style>

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Order #<?= e($order['id']) ?> (Table <?= e($order['table_no']) ?>)</h3>
  <div>
    <?php if ($order['status'] === 'OPEN'): ?>
      <!-- ✅ Payment Dropdown (POST form) -->
      <form method="post" action="<?= BASE_URL ?>/public/?r=orders/pay" class="d-inline">
        <input type="hidden" name="order_id" value="<?= e($order['id']) ?>">
        <div class="btn-group">
          <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
            Payment
          </button>
          <ul class="dropdown-menu">
            <li><button class="dropdown-item" type="submit" name="payment_method" value="CASH">Cash</button></li>
            <li><button class="dropdown-item" type="submit" name="payment_method" value="UPI">UPI</button></li>
            <li><button class="dropdown-item" type="submit" name="payment_method" value="CARD">Card</button></li>
          </ul>
        </div>
      </form>

      <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/public/?r=orders/cancel&id=<?= e($order['id']) ?>">Cancel</a>
    <?php endif; ?>
    <a class="btn btn-outline-primary" target="_blank" href="<?= BASE_URL ?>/public/?r=orders/receipt&id=<?= e($order['id']) ?>">Receipt</a>
  </div>
</div>

<div class="row g-3">
  <div class="col-md-7">
    <div class="card">
      <div class="card-header">Items</div>
      <div class="card-body">
        <table class="table table-sm">
          <thead><tr><th>Item</th><th>Price</th><th>Qty</th><th>Total</th><th></th></tr></thead>
          <tbody>
            <?php foreach($ois as $oi): ?>
              <tr>
                <td><?= e($oi['item_name']) ?></td>
                <td>₹ <?= e(number_format($oi['price'],2)) ?></td>
                <td>
                  <form class="d-inline" method="post" action="<?= BASE_URL ?>/public/?r=orders/update_item">
                    <input type="hidden" name="oi_id" value="<?= e($oi['id']) ?>">
                    <input type="hidden" name="order_id" value="<?= e($order['id']) ?>">
                    <input class="form-control form-control-sm" style="width:80px" type="number" name="qty" min="1" value="<?= e($oi['qty']) ?>">
                    <button class="btn btn-sm btn-outline-secondary">Update</button>
                  </form>
                </td>
                <td>₹ <?= e(number_format($oi['price']*$oi['qty'],2)) ?></td>
                <td><a class="btn btn-sm btn-outline-danger" href="<?= BASE_URL ?>/public/?r=orders/remove_item&oi_id=<?= e($oi['id']) ?>&order_id=<?= e($order['id']) ?>">Remove</a></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <div class="col-md-5">
    <div class="card">
      <div class="card-header">Add Item</div>
      <div class="card-body">
        <form class="row g-2" method="post" action="<?= BASE_URL ?>/public/?r=orders/add_item">
          <input type="hidden" name="order_id" value="<?= e($order['id']) ?>">
          <div class="col-12">
            <select class="form-select" name="item_id" required>
              <?php foreach($items as $i): ?>
                <option value="<?= e($i['id']) ?>"><?= e($i['name']) ?> - ₹ <?= e(number_format($i['price'],2)) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-6"><input class="form-control" type="number" min="1" name="qty" value="1"></div>
          <div class="col-6"><button class="btn btn-primary w-100">Add</button></div>
        </form>
        <hr>
        <!-- ✅ Discount Form -->
        <form class="row g-2" method="post" action="<?= BASE_URL ?>/public/?r=orders/discount">
          <input type="hidden" name="order_id" value="<?= e($order['id']) ?>">
          <div class="col-12">
            <label class="form-label">Discount (₹)</label>
            <input class="form-control" type="number" step="0.01" name="discount" value="<?= e($order['discount']) ?>">
          </div>
          <div class="col-12">
            <button class="btn btn-outline-secondary w-100">Apply</button>
          </div>
        </form>

        <hr>
<div>
  <div class="d-flex justify-content-between">
    <span>Subtotal</span>
    <strong>₹ <?= e(number_format($subtotal,2)) ?></strong>
  </div>
  <div class="d-flex justify-content-between">
    <span>Discount</span>
    <strong>- ₹ <?= e(number_format($discount,2)) ?></strong>
  </div>
  <?php if ($gst_enabled): ?>
    <div class="d-flex justify-content-between">
      <span>GST</span>
      <strong>₹ <?= e(number_format($tax,2)) ?></strong>
    </div>
  <?php endif; ?>
  <div class="d-flex justify-content-between fs-5">
    <span>Total</span>
    <strong>₹ <?= e(number_format($total,2)) ?></strong>
  </div>
</div>


        </div>
      </div>
    </div>
  </div>
</div>
