<?php

require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

// Require authentication
requireAuth();

// Get current business
$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

// Log activity
logActivity('order_new_view', 'Viewed new order page');

?>
<style>
  body {
    background-image: url("<?php echo BASE_URL; ?>/public/background.jpg");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
  }

  .container {
    background: rgba(255, 255, 255, 0.88);
    border-radius: 16px;
    padding: 2rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, .15);
    backdrop-filter: blur(3px);
    max-width: 500px;
    margin: 2rem auto;
  }

  .order-type-boxes {
    display: flex;
    gap: 1rem;
    justify-content: center;
    margin-bottom: 1rem;
  }

  .order-type-box {
    flex: 1;
    text-align: center;
    border: 2px solid #007bff;
    border-radius: 10px;
    padding: 1rem;
    cursor: pointer;
    transition: 0.3s;
    font-weight: 600;
    color: #007bff;
    background-color: #fff;
  }

  .order-type-box:hover {
    background-color: #e7f1ff;
  }

  .order-type-box.active {
    background-color: #007bff;
    color: white;
  }

  .form-control[readonly] {
    background-color: #f8f9fa !important;
    border: 1px solid #ccc;
    cursor: not-allowed;
  }
</style>

<div class="container">
  <h3 class="mb-4 text-center">Create New Order</h3>

  <form method="post" action="<?= BASE_URL ?>/public/?r=orders/new" id="orderForm">
    <!-- Order Type Boxes -->
    <div class="order-type-boxes">
      <div class="order-type-box active" data-type="table">Table</div>
      <div class="order-type-box" data-type="takeaway">Takeaway</div>
    </div>

    <input type="hidden" name="order_type" id="orderType" value="table">

    <!-- Table No -->
    <div class="mb-3" id="tableBox">
      <label class="form-label">Table No</label>
      <input class="form-control" type="text" name="table_no" id="tableNo" placeholder="e.g., T3">
    </div>

    <!-- Takeaway box (readonly, hidden initially) -->
    <div class="mb-3" id="takeawayBox" style="display: none;">
      <label class="form-label">Order Type</label>
      <input class="form-control" type="text" value="Takeaway" readonly>
    </div>

    <div class="mb-3">
      <label class="form-label">Customer Name</label>
      <input class="form-control" type="text" name="customer_name" placeholder="e.g., John Doe" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Mobile Number</label>
      <input class="form-control" 
             type="tel" 
             id="customerMobile"
             name="customer_mobile" 
             placeholder="10-digit mobile number" 
             pattern="[0-9]{10}" 
             maxlength="10" 
             title="Please enter exactly 10 digits"
             required>
    </div>

    <div class="text-center">
      <button type="submit" class="btn btn-primary px-4">Create Order</button>
    </div>
  </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const typeBoxes = document.querySelectorAll('.order-type-box');
  const orderTypeInput = document.getElementById('orderType');
  const tableBox = document.getElementById('tableBox');
  const takeawayBox = document.getElementById('takeawayBox');
  const tableNo = document.getElementById('tableNo');
  const customerMobile = document.getElementById('customerMobile');

  // Prevent alphabets and special characters in phone number
  customerMobile.addEventListener('input', function () {
    this.value = this.value.replace(/[^0-9]/g, ''); // remove non-numeric chars
  });

  typeBoxes.forEach(box => {
    box.addEventListener('click', () => {
      typeBoxes.forEach(b => b.classList.remove('active'));
      box.classList.add('active');

      const type = box.getAttribute('data-type');
      orderTypeInput.value = type;

      if (type === 'table') {
        tableBox.style.display = 'block';
        takeawayBox.style.display = 'none';
        tableNo.readOnly = false;
        tableNo.value = '';
      } else {
        tableBox.style.display = 'none';
        takeawayBox.style.display = 'block';
        tableNo.readOnly = true;
        tableNo.value = 'Takeaway';
      }
    });
  });
});
</script>
