<?php

require_once __DIR__ . '/../../db.php';
require_once __DIR__ . '/../../helpers.php';
require_once __DIR__ . '/../../session.php';

// Require authentication for all views
requireAuth();

// Get current business settings
$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

$settings = one('SELECT * FROM settings WHERE id=?', [$current_business['business_id']]);
if (!$settings) {
    // Fallback to default settings if business settings not found
    $settings = one('SELECT * FROM settings WHERE id=1');
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= e($settings['business_name'] ?? 'Billing') ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
  <style>
    body { padding-top: 70px; }
    .nav-link.active { font-weight: 600; }
    /*.navbar{ background-color:yellow}*/

  body { padding-top: 70px; }
  .nav-link.active { font-weight: 600; }

  .custom-navbar {
    background-color: rgb(213 135 42) !important;
  }

  .custom-navbar .navbar-brand,
  .custom-navbar .nav-link {
    color: black !important;
  }

  .custom-navbar .nav-link:hover {
    color: white !important;

  }


  </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top custom-navbar">
  <a class="navbar-brand d-flex align-items-center" href="<?= BASE_URL ?>/public/r?=dashboard">
  <img src="<?= BASE_URL ?>/public/logo.jpg" alt="Logo" 
       style="height:30px; width:30px; margin-right:8px; border-radius:50%;">
  <?= e($settings['business_name'] ?? 'Billing') ?>
</a>


    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMenu"
            aria-controls="navbarMenu" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarMenu">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/?r=orders/new">New Orders</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/?r=orders">Orders</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/?r=items">Items</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/?r=categories">Categories</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/?r=reports">Reports</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/?r=settings">Settings</a></li>
      </ul>
      <ul class="navbar-nav">
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <?= e($current_business['business_name']) ?>
          </a>
          <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
            <li><a class="dropdown-item" href="<?= BASE_URL ?>/public/?r=settings">Settings</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item" href="<?= BASE_URL ?>/public/logout.php">Logout</a></li>
          </ul>
        </li>
      </ul>
    </div>
  </div>
</nav>

<div class="container">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
