<?php 

require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

// Require authentication
requireAuth();

// Get current business
$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

// Log activity
logActivity('items_view', 'Viewed items list');

// Fetch data from DB
$items = all_rows("
    SELECT i.*, c.name AS category_name 
    FROM items i 
    LEFT JOIN categories c ON c.id=i.category_id 
    WHERE i.business_id = ?
    ORDER BY i.name
", [$current_business['business_id']]);

$cats = all_rows("SELECT * FROM categories WHERE business_id = ? ORDER BY name", [$current_business['business_id']]);
?>
<style>
  body {
    background-image: url("<?php echo BASE_URL; ?>/public/background.jpg");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
  }
  .container{
    background: rgba(255, 255, 255, 0.88);
    border-radius: 16px;
    padding: 1rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, .15);
    backdrop-filter: blur(2px);
  }
</style>

<div class="d-flex justify-content-between align-items-center mb-3">
    <h3>Items</h3>
</div>

<form method="post" action="<?= BASE_URL ?>/public/?r=items/import" enctype="multipart/form-data" class="mb-3">
    <input type="file" name="excel_file" accept=".xlsx, .xls" required>
    <button class="btn btn-success">Import Excel File</button>
</form>

<div class="card mb-3">
    <div class="card-header">Add Item</div>
    <div class="card-body">
        <form method="post" action="<?= BASE_URL ?>/public/?r=items/create" class="d-flex flex-wrap gap-2">
            <input class="form-control flex-grow-1" style="min-width:180px" name="name" placeholder="Name" required>
            <input class="form-control" style="max-width:150px" name="price" placeholder="Price" type="number" step="0.01" required>
            <input class="form-control" style="max-width:150px" name="sku" placeholder="SKU">
            <select class="form-select flex-grow-1" style="min-width:180px" name="category_id">
                <option value="">-- Category --</option>
                <?php foreach($cats as $c): ?>
                    <option value="<?= e($c['id']) ?>"><?= e($c['name']) ?></option>
                <?php endforeach; ?>
            </select>
            <button class="btn btn-primary">Save</button>
        </form>
    </div>
</div>

<table class="table table-striped">
    <thead>
        <tr>
            <th>Name</th>
            <th>Price</th>
            <th>SKU</th>
            <th>Category</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($items as $i): ?>
        <tr>
            <td><?= e($i['name']) ?></td>
            <td>₹ <?= e(number_format($i['price'], 2)) ?></td>
            <td><?= e($i['sku']) ?></td>
            <td><?= e($i['category_name']) ?></td>
            <td>
                <?php if ($i['is_active']): ?>
                    <a class="btn btn-sm btn-warning"
                       href="<?= BASE_URL ?>/public/?r=items/set_status&id=<?= e($i['id']) ?>&status=0">
                       Active
                    </a>
                <?php else: ?>
                    <a class="btn btn-sm btn-success"
                       href="<?= BASE_URL ?>/public/?r=items/set_status&id=<?= e($i['id']) ?>&status=1">
                       Inactive
                    </a>
                <?php endif; ?>
            </td>
            <td>
                <a class="btn btn-sm btn-outline-danger" 
                   href="<?= BASE_URL ?>/public/?r=items/delete&id=<?= e($i['id']) ?>" 
                   onclick="return confirm('Delete?')">Delete</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>
