<?php

require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

// Require authentication
requireAuth();

// Get current business
$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

// Log activity
logActivity('categories_view', 'Viewed categories list');

$cats = all_rows("SELECT * FROM categories WHERE business_id = ? ORDER BY name", [$current_business['business_id']]);
?>
<style>
  body {
    background-image: url("<?php echo BASE_URL;?>/public/background.jpg");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
  }
  .container{
    background: rgba(255, 255, 255, 0.88);
    border-radius: 16px;
    padding: 1rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, .15);
    backdrop-filter: blur(2px);
  }
</style>

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Categories</h3>
  <form class="d-flex" method="post" action="<?= BASE_URL ?>/public/?r=categories/create">
    <input class="form-control me-2" type="text" name="name" placeholder="New category name" required>
    <button class="btn btn-primary" type="submit">Add</button>
  </form>
</div>

<table class="table table-striped">
  <thead>
    <tr>
      <th>Id</th>
      <th>Name</th>
      <th>Status</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
  <?php foreach($cats as $c): ?>
    <tr>
      <td><?= e($c['id']) ?></td>
      <td><?= e($c['name']) ?></td>
      <td>
        <?php if ($c['is_active']): ?>
          <a class="btn btn-sm btn-warning"
             href="<?= BASE_URL ?>/public/?r=categories/set_status&id=<?= e($c['id']) ?>&status=0">
             Active
          </a>
        <?php else: ?>
          <a class="btn btn-sm btn-success"
             href="<?= BASE_URL ?>/public/?r=categories/set_status&id=<?= e($c['id']) ?>&status=1">
             Inactive
          </a>
        <?php endif; ?>
      </td>
      <td>
        <a class="btn btn-sm btn-outline-danger" 
           href="<?= BASE_URL ?>/public/?r=categories/delete&id=<?= e($c['id']) ?>" 
           onclick="return confirm('Delete?')">Delete</a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
