<?php
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/session.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $business_name = trim($_POST['business_name']);
    $phone         = trim($_POST['phone']);
    $address       = trim($_POST['address']);
    $password_hash = password_hash($_POST['password'], PASSWORD_BCRYPT);

    // ✅ Check if business already exists
    $exists = one("SELECT * FROM settings WHERE phone = ?", [$phone]);
    if ($exists) {
        $error = "⚠️ This phone number is already registered!";
        logActivity('registration_failed', 'Phone number already exists: ' . $phone);
    } else {
        // ✅ Insert new business
        $insert = query(
            "INSERT INTO settings (business_name, address, phone, password, gstin, gst_rate, gst_applicable)
             VALUES (?, ?, ?, ?, '', 5.00, 1)",
            [$business_name, $address, $phone, $password_hash]
        );

        if ($insert) {
            $restaurant_id = last_id();
            $start  = date('Y-m-d H:i:s');
            $expiry = date('Y-m-d H:i:s', strtotime('+1 month')); // ✅ Changed from +1 hour → +1 month

            // ✅ Insert default 1-month demo subscription
            query(
                "INSERT INTO subscriptions (restaurant_id, plan, start_date, expiry_date, status)
                 VALUES (?, 'demo-1month', ?, ?, 'active')",
                [$restaurant_id, $start, $expiry]
            );

            logActivity('registration_success', 'New business registered: ' . $business_name);
            header("Location: login.php?registered=1");
            exit;
        } else {
            $error = "❌ Registration failed! Please try again.";
            logActivity('registration_failed', 'Database error during registration');
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Business Registration | Restaurant Billing</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
/* --- Reset --- */
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
  font-family: 'Poppins', sans-serif;
}

/* --- Background --- */
body {
  background: linear-gradient(135deg, #4f46e5, #9333ea);
  height: 100vh;
  display: flex;
  justify-content: center;
  align-items: center;
}

/* --- Container --- */
.container {
  background: #fff;
  width: 400px;
  padding: 40px 30px;
  border-radius: 15px;
  box-shadow: 0 8px 25px rgba(0,0,0,0.2);
  text-align: center;
  animation: fadeIn 0.8s ease;
}

/* --- Title --- */
.container h2 {
  color: #333;
  font-weight: 600;
  margin-bottom: 25px;
  font-size: 26px;
}

/* --- Form Inputs --- */
.container input[type="text"],
.container input[type="password"],
.container textarea {
  width: 100%;
  padding: 12px;
  margin: 10px 0 20px 0;
  border: 1px solid #ccc;
  border-radius: 8px;
  font-size: 15px;
  transition: all 0.3s ease;
}

.container input:focus,
.container textarea:focus {
  border-color: #4f46e5;
  outline: none;
  box-shadow: 0 0 6px rgba(79,70,229,0.3);
}

.container textarea {
  resize: vertical;
  min-height: 80px;
  max-height: 150px;
}

/* --- Button --- */
.container button {
  width: 100%;
  padding: 12px;
  border: none;
  background: #4f46e5;
  color: white;
  font-weight: 600;
  border-radius: 8px;
  font-size: 16px;
  cursor: pointer;
  transition: background 0.3s ease;
}

.container button:hover {
  background: #3730a3;
}

/* --- Error Message --- */
.container p[style] {
  background: #fee2e2;
  color: #b91c1c;
  padding: 10px;
  border-radius: 6px;
  margin-bottom: 15px;
  font-size: 14px;
}

/* --- Footer --- */
.container p {
  margin-top: 20px;
  font-size: 14px;
}

.container a {
  color: #4f46e5;
  text-decoration: none;
  font-weight: 500;
}

.container a:hover {
  text-decoration: underline;
}

/* --- Animation --- */
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(-15px); }
  to { opacity: 1; transform: translateY(0); }
}

/* --- Responsive --- */
@media (max-width: 450px) {
  .container {
    width: 90%;
    padding: 30px 20px;
  }
}
</style>
</head>
<body>
<div class="container">
  <h2>Business Registration</h2>
  <?php if(isset($error)) echo "<p style='color:red;'>$error</p>"; ?>

  <form method="POST">
      <input type="text" name="business_name" placeholder="Business Name" required>
      <input type="text" name="phone" placeholder="Phone Number" required>
      <textarea name="address" placeholder="Business Address" required></textarea>
      <input type="password" name="password" placeholder="Password" required>
      <button type="submit">Register</button>
  </form>

  <p>Already registered? <a href="login.php">Login</a></p>
</div>
</body>
</html>
