<?php
require_once __DIR__ . '/../src/db.php';

$today = date('Y-m-d');

// Step 1: Expire subscriptions that are past due
query("UPDATE subscriptions
       SET status='expired'
       WHERE expiry_date < ? AND status='active'", [$today]);

// Step 2: Optional - notify restaurants whose plans expire soon (3 days before expiry)
$soon = all_rows("SELECT restaurant_id, expiry_date
                  FROM subscriptions
                  WHERE DATEDIFF(expiry_date, ?) = 3 AND status='active'", [$today]);

foreach ($soon as $row) {
    // Example: send reminder email or SMS here
    // You can add email/SMS notification logic here
    error_log("Subscription expiring soon for restaurant ID: " . $row['restaurant_id'] . " on " . $row['expiry_date']);
}

// Step 3: Log cron execution
error_log("Renewal check cron executed successfully: " . date('Y-m-d H:i:s'));

echo "Cron executed successfully: " . date('Y-m-d H:i:s');
?>
