# Restaurant Billing System API Documentation

This document provides comprehensive API documentation for the Restaurant Billing System Android app integration.

## Base URL
```
http://your-domain.com/php_restaurant_billing/src/api/
```

## Authentication
All APIs use a simple token-based authentication system. Include the token in the Authorization header:
```
Authorization: Bearer your_token_here
```

## Common Response Format
All APIs return responses in the following format:
```json
{
    "status": true/false,
    "message": "Description of the result",
    "data": {} // Actual data (null if error)
}
```

## API Endpoints

### 1. Authentication API (`auth.php`)

#### Login
- **URL**: `auth.php?action=login`
- **Method**: POST
- **Body**:
```json
{
    "username": "admin",
    "password": "admin123"
}
```
- **Response**:
```json
{
    "status": true,
    "message": "Login successful",
    "data": {
        "token": "base64_encoded_token",
        "user": {
            "id": 1,
            "username": "admin",
            "role": "admin"
        }
    }
}
```

#### Validate Token
- **URL**: `auth.php?action=validate`
- **Method**: GET
- **Headers**: `Authorization: Bearer your_token`

### 2. Categories API (`categories.php`)

#### Get All Categories
- **URL**: `categories.php?action=list`
- **Method**: GET

#### Get Single Category
- **URL**: `categories.php?action=get&id=1`
- **Method**: GET

#### Create Category
- **URL**: `categories.php?action=create`
- **Method**: POST
- **Body**:
```json
{
    "name": "Chinese Food"
}
```

#### Update Category
- **URL**: `categories.php?action=update`
- **Method**: PUT
- **Body**:
```json
{
    "id": 1,
    "name": "Updated Category Name",
    "is_active": 1
}
```

#### Delete Category
- **URL**: `categories.php?action=delete`
- **Method**: DELETE
- **Body**:
```json
{
    "id": 1
}
```

### 3. Items API (`items.php`)

#### Get All Items
- **URL**: `items.php?action=list`
- **Method**: GET
- **Query Parameters**:
  - `search`: Search by item name
  - `category_id`: Filter by category
  - `active_only`: Show only active items (default: 1)

#### Get Single Item
- **URL**: `items.php?action=get&id=1`
- **Method**: GET

#### Search Items
- **URL**: `items.php?action=search&q=chicken`
- **Method**: GET

#### Create Item
- **URL**: `items.php?action=create`
- **Method**: POST
- **Body**:
```json
{
    "name": "Chicken Biryani",
    "price": 250.00,
    "sku": "CB001",
    "category_id": 1
}
```

#### Update Item
- **URL**: `items.php?action=update`
- **Method**: PUT
- **Body**:
```json
{
    "id": 1,
    "name": "Updated Item Name",
    "price": 300.00,
    "sku": "UPD001",
    "category_id": 1,
    "is_active": 1
}
```

#### Delete Item
- **URL**: `items.php?action=delete`
- **Method**: DELETE
- **Body**:
```json
{
    "id": 1
}
```

### 4. Orders API (`orders.php`)

#### Get All Orders
- **URL**: `orders.php?action=list`
- **Method**: GET
- **Query Parameters**:
  - `status`: Filter by status (OPEN, PAID, CANCELLED)
  - `limit`: Number of orders to fetch (default: 100)
  - `from_date`: Start date (YYYY-MM-DD)
  - `to_date`: End date (YYYY-MM-DD)

#### Get Single Order
- **URL**: `orders.php?action=get&id=1`
- **Method**: GET

#### Get Order Summary
- **URL**: `orders.php?action=summary`
- **Method**: GET
- **Query Parameters**:
  - `from_date`: Start date (default: first day of month)
  - `to_date`: End date (default: today)

#### Create Order
- **URL**: `orders.php?action=create`
- **Method**: POST
- **Body**:
```json
{
    "order_type": "table",
    "table_no": "5",
    "customer_name": "John Doe",
    "customer_mobile": "9876543210",
    "items": [
        {
            "item_id": 1,
            "qty": 2
        },
        {
            "item_id": 2,
            "qty": 1
        }
    ]
}
```

#### Add Item to Order
- **URL**: `orders.php?action=add_item`
- **Method**: POST
- **Body**:
```json
{
    "order_id": 1,
    "item_id": 3,
    "qty": 1
}
```

#### Update Item Quantity
- **URL**: `orders.php?action=update_item`
- **Method**: POST
- **Body**:
```json
{
    "oi_id": 1,
    "order_id": 1,
    "qty": 3
}
```

#### Remove Item from Order
- **URL**: `orders.php?action=remove_item`
- **Method**: POST
- **Body**:
```json
{
    "oi_id": 1,
    "order_id": 1
}
```

#### Apply Discount
- **URL**: `orders.php?action=discount`
- **Method**: POST
- **Body**:
```json
{
    "order_id": 1,
    "discount": 50.00
}
```

#### Process Payment
- **URL**: `orders.php?action=pay`
- **Method**: POST
- **Body**:
```json
{
    "order_id": 1,
    "payment_method": "CASH"
}
```

#### Cancel Order
- **URL**: `orders.php?action=cancel`
- **Method**: POST
- **Body**:
```json
{
    "order_id": 1
}
```

### 5. Customers API (`customers.php`)

#### Get All Customers
- **URL**: `customers.php?action=list`
- **Method**: GET
- **Query Parameters**:
  - `search`: Search by name or mobile
  - `limit`: Number of customers to fetch (default: 100)

#### Get Single Customer
- **URL**: `customers.php?action=get&id=1`
- **Method**: GET

#### Search Customers
- **URL**: `customers.php?action=search&q=john`
- **Method**: GET

#### Create Customer
- **URL**: `customers.php?action=create`
- **Method**: POST
- **Body**:
```json
{
    "name": "John Doe",
    "mobile_no": "9876543210"
}
```

#### Update Customer
- **URL**: `customers.php?action=update`
- **Method**: PUT
- **Body**:
```json
{
    "sno": 1,
    "name": "John Smith",
    "mobile_no": "9876543210"
}
```

#### Delete Customer
- **URL**: `customers.php?action=delete`
- **Method**: DELETE
- **Body**:
```json
{
    "sno": 1
}
```

### 6. Settings API (`settings.php`)

#### Get Settings
- **URL**: `settings.php?action=get`
- **Method**: GET

#### Update Settings
- **URL**: `settings.php?action=update`
- **Method**: POST/PUT
- **Body**:
```json
{
    "business_name": "My Restaurant",
    "phone": "+91-9876543210",
    "address": "123 Main Street, City",
    "gstin": "22ABCDE1234F1Z5",
    "gst_rate": 18.00,
    "gst_applicable": 1
}
```

### 7. Dashboard API (`dashboard.php`)

#### Get Dashboard Stats
- **URL**: `dashboard.php?action=stats`
- **Method**: GET

**Response includes**:
- Today's statistics
- Month's statistics
- Open orders
- Recent paid orders
- Top selling items
- Payment method breakdown

### 8. Reports API (`reports.php`)

#### Get Sales Report
- **URL**: `reports.php?action=sales`
- **Method**: GET
- **Query Parameters**:
  - `from`: Start date (YYYY-MM-DD)
  - `to`: End date (YYYY-MM-DD)
  - `limit`: Number of orders (default: 1000)

#### Get Items Report
- **URL**: `reports.php?action=items`
- **Method**: GET
- **Query Parameters**:
  - `from`: Start date
  - `to`: End date

#### Get Customers Report
- **URL**: `reports.php?action=customers`
- **Method**: GET
- **Query Parameters**:
  - `from`: Start date
  - `to`: End date

#### Get Daily Sales Report
- **URL**: `reports.php?action=daily`
- **Method**: GET
- **Query Parameters**:
  - `from`: Start date
  - `to`: End date

#### Export CSV
- **URL**: `reports.php?action=export`
- **Method**: GET
- **Query Parameters**:
  - `from`: Start date
  - `to`: End date

### 9. Receipt API (`receipt.php`)

#### Get Receipt Data
- **URL**: `receipt.php?action=get&id=1`
- **Method**: GET

#### Generate Print Receipt
- **URL**: `receipt.php?action=print&id=1`
- **Method**: GET

## Error Codes

- **200**: Success
- **400**: Bad Request (Invalid input)
- **401**: Unauthorized (Invalid token)
- **404**: Not Found
- **405**: Method Not Allowed
- **409**: Conflict (Duplicate data)
- **500**: Internal Server Error

## Usage Examples

### Android Integration Example

```java
// Login example
String loginUrl = baseUrl + "auth.php?action=login";
JSONObject loginData = new JSONObject();
loginData.put("username", "admin");
loginData.put("password", "admin123");

// Make POST request and get token
String token = response.getString("data").getString("token");

// Use token in subsequent requests
request.setHeader("Authorization", "Bearer " + token);

// Get items
String itemsUrl = baseUrl + "items.php?action=list";
// Make GET request

// Create order
String createOrderUrl = baseUrl + "orders.php?action=create";
JSONObject orderData = new JSONObject();
orderData.put("customer_name", "John Doe");
orderData.put("customer_mobile", "9876543210");
orderData.put("order_type", "table");
orderData.put("table_no", "5");

JSONArray items = new JSONArray();
JSONObject item1 = new JSONObject();
item1.put("item_id", 1);
item1.put("qty", 2);
items.put(item1);
orderData.put("items", items);

// Make POST request
```

## Notes

1. All APIs support CORS for cross-origin requests
2. Date formats should be in YYYY-MM-DD format
3. Prices should be in decimal format (e.g., 250.00)
4. The system automatically calculates GST based on settings
5. Orders can only be modified when status is 'OPEN'
6. Token expires after 24 hours
