<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Subscription Plans</title>
  <style>
    * { box-sizing: border-box; margin: 0; padding: 0; font-family: Arial, sans-serif; }
    body { background: #f4f6f8; padding: 40px; }

    .container {
      max-width: 1100px;
      margin: auto;
      text-align: center;
    }

    h1 { font-size: 36px; margin-bottom: 10px; }
    p.subtitle { color: #555; margin-bottom: 40px; }

    .plans {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
      gap: 25px;
    }

    .card {
      background: #fff;
      border-radius: 12px;
      padding: 30px;
      box-shadow: 0 10px 25px rgba(0,0,0,0.08);
      transition: transform 0.3s ease;
    }

    .card:hover { transform: translateY(-8px); }

    .card.popular {
      border: 3px solid #4f46e5;
    }

    .badge {
      background: #4f46e5;
      color: #fff;
      padding: 6px 14px;
      border-radius: 20px;
      font-size: 13px;
      display: inline-block;
      margin-bottom: 15px;
    }

    .plan-title { font-size: 24px; margin-bottom: 10px; }
    .price { font-size: 34px; margin: 15px 0; }
    .price span { font-size: 16px; color: #777; }

    ul { list-style: none; text-align: left; margin: 25px 0; }
    ul li { margin-bottom: 12px; color: #444; }

    button {
      width: 100%;
      padding: 14px;
      border: none;
      border-radius: 8px;
      font-size: 16px;
      cursor: pointer;
      background: #4f46e5;
      color: white;
      transition: background 0.3s ease;
    }

    button:hover { background: #3730a3; }

    .free button { background: #10b981; }
    .free button:hover { background: #059669; }

    footer {
      margin-top: 40px;
      color: #777;
      font-size: 14px;
    }
  </style>
</head>
<body>

  <div class="container">
    <h1>Choose Your Plan</h1>
    <p class="subtitle">Simple and transparent pricing for everyone</p>

    <div class="plans">

      <div class="card free">
        <div class="plan-title">Free</div>
        <div class="price">₹0 <span>/month</span></div>
        <ul>
          <li>✔ Basic Dashboard</li>
          <li>✔ 10 Products</li>
          <li>✔ Limited Support</li>
          <li>✖ GST Reports</li>
        </ul>
        <button>Get Started</button>
      </div>

      <div class="card popular">
        <div class="badge">Most Popular</div>
        <div class="plan-title">Standard</div>
        <div class="price">₹499 <span>/month</span></div>
        <ul>
          <li>✔ Full Dashboard</li>
          <li>✔ Unlimited Products</li>
          <li>✔ GST Billing</li>
          <li>✔ Email Support</li>
        </ul>
        <button>Subscribe Now</button>
      </div>

      <div class="card">
        <div class="plan-title">Premium</div>
        <div class="price">₹999 <span>/month</span></div>
        <ul>
          <li>✔ Everything in Standard</li>
          <li>✔ Inventory Management</li>
          <li>✔ Advanced Reports</li>
          <li>✔ Priority Support</li>
        </ul>
        <button>Go Premium</button>
      </div>

    </div>

    <footer>
      © 2026 Your Company Name. All rights reserved.
    </footer>
  </div>

</body>
</html>