<?php

require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

// Require authentication
requireAuth();

// Get current business
$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

// Log activity
logActivity('settings_view', 'Viewed settings page');

// Fetch only the logged-in business settings
$business_id = $current_business['business_id'];
$settings = one("SELECT * FROM settings WHERE id = ?", [$business_id]);

if (!$settings) {
    echo "<p>No settings found for your business.</p>";
    exit;
}
?>
<style>
  body {
    background-image: url("<?php echo BASE_URL; ?>/public/background.jpg");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
  }
  .container{
    background: rgba(255, 255, 255, 0.88);
    border-radius: 16px;
    padding: 1rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, .15);
    backdrop-filter: blur(2px);
  }
</style>

<h3>Settings</h3>
<form class="row g-3" method="post" action="<?= BASE_URL ?>/public/?r=settings/save">
  <div class="col-md-6">
    <label class="form-label">Business Name</label>
    <input class="form-control" name="business_name" value="<?= e($settings['business_name']) ?>">
  </div>
  <div class="col-md-6">
    <label class="form-label">Phone</label>
    <input class="form-control" name="phone" value="<?= e($settings['phone']) ?>">
  </div>
  <div class="col-md-12">
    <label class="form-label">Address</label>
    <input class="form-control" name="address" value="<?= e($settings['address']) ?>">
  </div>

  <div class="col-md-6">
    <label class="form-label">GST Applicable?</label>
    <select class="form-select" name="gst_applicable" id="gst_applicable">
      <option value="1" <?= $settings['gst_applicable'] ? 'selected' : '' ?>>Yes</option>
      <option value="0" <?= !$settings['gst_applicable'] ? 'selected' : '' ?>>No</option>
    </select>
  </div>

  <div class="col-md-6" id="gst_rate_field" style="<?= !$settings['gst_applicable'] ? 'display:none;' : '' ?>">
    <label class="form-label">GST Rate (%)</label>
    <input class="form-control" type="number" step="0.01" name="gst_rate" value="<?= e($settings['gst_rate']) ?>">
  </div>

  <div class="col-md-6" id="gstin_field" style="<?= !$settings['gst_applicable'] ? 'display:none;' : '' ?>">
    <label class="form-label">GSTIN</label>
    <input class="form-control" type="text" name="gstin" id="gstin" value="<?= e($settings['gstin']) ?>">
  </div>

  <div class="col-12">
    <button class="btn btn-primary">Save</button>
  </div>
</form>

<script>
document.getElementById("gst_applicable").addEventListener("change", function() {
    const gstRateField = document.getElementById("gst_rate_field");
    const gstinField   = document.getElementById("gstin_field");
    const gstinInput   = document.getElementById("gstin");

    if (this.value == "1") {
        gstRateField.style.display = "block";
        gstinField.style.display   = "block";
        gstinInput.setAttribute("required", "required"); // GSTIN required if Yes
    } else {
        gstRateField.style.display = "none";
        gstinField.style.display   = "none";
        gstinInput.removeAttribute("required"); // Not required if No
    }
});
</script>
