<?php
require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

// Require authentication
requireAuth();

$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

// NOTE: This template appears to contain a destructive operation.
// Removing accidental delete-all behavior; render orders list instead.
$business_id = $current_business['business_id'];
$orders = all_rows(
    "SELECT 
        o.*,
        k.kot_status
     FROM orders o
     LEFT JOIN kots k ON k.order_id = o.id
     WHERE o.business_id = ?
     ORDER BY o.created_at DESC
     LIMIT 200",
    [$business_id]
);

?>

<style>
  body {
    background-image: url("<?php echo BASE_URL; ?>/public/background.jpg");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
  }
  .container{
    background: rgba(255, 255, 255, 0.88);
    border-radius: 16px;
    padding: 1rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, .15);
    backdrop-filter: blur(2px);
  }
</style>

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Orders</h3>
  <div>
    <a class="btn btn-primary" href="<?= BASE_URL ?>/public?r=order/new">New Order</a>
  </div>
</div>


<table class="table table-striped">
  <thead>
    <tr>
      <th>ID</th>
      <th>Date</th>
      <th>Table</th>
      <th>Status</th>
      <th>Total</th>
      <th></th>
    </tr>
  </thead>
  <tbody>

<?php foreach ($orders as $o): ?>
<?php
// ✅ FINAL STATUS LOGIC (WITH PAID)
if ($o['status'] === 'CANCELLED') {
    $statusText = 'Cancelled';
    $badgeClass = 'bg-danger';

} elseif ($o['status'] === 'PAID') {
    $statusText = 'Paid';
    $badgeClass = 'bg-success';

} else {
    $statusText = $o['kot_status'] ?? 'Pending';

    $badgeClass = match ($statusText) {
        'Pending'   => 'bg-secondary',
        'Preparing' => 'bg-warning text-dark',
        'Ready'     => 'bg-success',
        'Updated'   => 'bg-dark',
        default     => 'bg-secondary'
    };
}

?>

<tr>
  <td><?= e($o['id']) ?></td>
  <td><?= e($o['created_at']) ?></td>
  <td><?= e($o['table_no']) ?></td>

  <td>
    <span class="badge <?= $badgeClass ?>">
      <?= e($statusText) ?>
    </span>
  </td>

  <td>₹ <?= e(number_format($o['total'], 2)) ?></td>

  <td>
    <a class="btn btn-sm btn-outline-primary"
       href="<?= BASE_URL ?>/public/?r=orders/show&id=<?= e($o['id']) ?>">
       Open
    </a>
  </td>
</tr>

<?php endforeach; ?>

  </tbody>
</table>
