<?php
require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

requireAuth();

/* =========================
   UPDATE KOT STATUS + MARK SENT QTY
========================= */
if (isset($_POST['update_kot'])) {

    $order_id = (int)$_POST['order_id'];

    // Update KOT status
    query(
        "UPDATE kots SET kot_status=?, updated_at=NOW() WHERE order_id=?",
        [$_POST['kot_status'], $order_id]
    );

    // Mark current qty as sent
    query(
        "UPDATE order_items 
         SET last_kot_qty = qty
         WHERE order_id = ?",
        [$order_id]
    );
}

/* =========================
   FETCH KOT DATA
========================= */
$rows = db()->query("
    SELECT 
        o.id AS order_id,
        o.table_no,
        o.created_at,
        k.kot_status,
        oi.item_name,
        oi.qty,
        oi.last_kot_qty,
        oi.notes
    FROM orders o
    JOIN kots k ON k.order_id = o.id
    JOIN order_items oi ON oi.order_id = o.id
    WHERE o.status = 'OPEN'
    ORDER BY o.created_at DESC, oi.id ASC
")->fetchAll(PDO::FETCH_ASSOC);

$kots = [];

foreach ($rows as $r) {

    $oid   = $r['order_id'];
    $total = (int)$r['qty'];
    $sent  = (int)$r['last_kot_qty'];
    $diff  = $total - $sent;

    if (!isset($kots[$oid])) {
        $kots[$oid] = [
            'order_id'   => $oid,
            'table_no'   => $r['table_no'],
            'created_at' => $r['created_at'],
            'kot_status' => $r['kot_status'],
            'items'      => [],
            'updated'    => []
        ];
    }

    /* FIRST TIME ORDER */
    if ($sent === 0) {
        $kots[$oid]['items'][] = [
            'name'  => $r['item_name'],
            'qty'   => $total,
            'notes' => $r['notes']
        ];
        continue;
    }

    /* ALREADY SENT ITEMS */
    if ($sent > 0) {
        $kots[$oid]['items'][] = [
            'name'  => $r['item_name'],
            'qty'   => $sent,
            'notes' => $r['notes']
        ];
    }

    /* UPDATED ITEMS → ONLY NEW QTY */
    if ($diff > 0) {
        $kots[$oid]['updated'][] = [
            'name' => $r['item_name'],
            'qty'  => $diff
        ];
    }
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Kitchen Order Tickets</title>

<style>
body {
    background-image: url("<?php echo BASE_URL; ?>/public/background.jpg");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
    color:black;
    font-family:Arial, sans-serif;
  }
.kot {
    background:#fff;
    padding:15px;
    margin:15px;
    border-radius:12px;
    border-left:6px solid #fdcb6e;
}
.Pending   { border-color:#fdcb6e; }
.Preparing { border-color:#0984e3; }
.Ready     { border-color:#00b894; }

.header {
    display:flex;
    justify-content:space-between;
    font-weight:bold;
    margin-bottom:8px;
}

.item {
    display:flex;
    justify-content:space-between;
    padding:5px 0;
    border-bottom:1px dashed #ccc;
}

.updated-box {
    background:#fff3cd;
    padding:10px;
    border-radius:8px;
    margin-top:10px;
}

.qty { font-weight:bold; }
.notes { font-size:12px; color:#e17055; }
</style>
</head>

<body>

<h2>🍳 Kitchen Order Tickets</h2>

<?php foreach ($kots as $k): ?>
<div class="kot <?= $k['kot_status'] ?>">

    <div class="header">
        <span>Order #<?= $k['order_id'] ?> | Table <?= htmlspecialchars($k['table_no']) ?></span>
        <span><?= date('h:i A', strtotime($k['created_at'])) ?></span>
    </div>

    <!-- SENT ITEMS -->
    <?php foreach ($k['items'] as $i): ?>
        <div class="item">
            <span>
                <?= htmlspecialchars($i['name']) ?>
                <?php if (!empty($i['notes'])): ?>
                    <div class="notes">📝 <?= htmlspecialchars($i['notes']) ?></div>
                <?php endif; ?>
            </span>
            <span class="qty">× <?= $i['qty'] ?></span>
        </div>
    <?php endforeach; ?>

    <!-- UPDATED ITEMS -->
    <?php if (!empty($k['updated'])): ?>
        <div class="updated-box">
            <strong>🔄 UPDATED ITEMS</strong>
            <?php foreach ($k['updated'] as $u): ?>
                <div class="item">
                    <span><?= htmlspecialchars($u['name']) ?></span>
                    <span class="qty">× <?= $u['qty'] ?></span>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <form method="post">
        <input type="hidden" name="order_id" value="<?= $k['order_id'] ?>">
        <select name="kot_status">
            <?php foreach (['Pending','Preparing','Ready'] as $s): ?>
                <option <?= $k['kot_status']===$s?'selected':'' ?>><?= $s ?></option>
            <?php endforeach; ?>
        </select>
        <button name="update_kot">Update</button>
    </form>

</div>
<?php endforeach; ?>

</body>
</html>
