<?php
require_once __DIR__ . '/config.php';

function db(): PDO {
    static $pdo = null;
    if ($pdo) return $pdo;

    $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4';
    $opt = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];
    $pdo = new PDO($dsn, DB_USER, DB_PASS, $opt);
    // Ensure schema is up to date for datetime storage
    try {
        $stmt = $pdo->prepare("SELECT DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = 'subscriptions' AND COLUMN_NAME = 'start_date'");
        $stmt->execute([DB_NAME]);
        $startType = $stmt->fetchColumn();
        $stmt = $pdo->prepare("SELECT DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = 'subscriptions' AND COLUMN_NAME = 'expiry_date'");
        $stmt->execute([DB_NAME]);
        $expiryType = $stmt->fetchColumn();
        if ($startType === 'date') {
            $pdo->exec("ALTER TABLE subscriptions MODIFY start_date DATETIME NOT NULL");
        }
        if ($expiryType === 'date') {
            $pdo->exec("ALTER TABLE subscriptions MODIFY expiry_date DATETIME NOT NULL");
        }
    } catch (Throwable $e) {
        // Ignore schema adjustments failures to avoid blocking app
    }
    return $pdo;
}

// ✅ Execute a query (insert/update/delete)
function query(string $sql, array $params = []) {
    $stmt = db()->prepare($sql);
    $stmt->execute($params);
    return $stmt;
}

// ✅ Fetch one row
function one(string $sql, array $params = []) {
    $stmt = query($sql, $params);
    return $stmt->fetch();
}

// ✅ Fetch all rows
function all_rows(string $sql, array $params = []) {
    return query($sql, $params)->fetchAll();
}

// ✅ Get last inserted ID safely
function last_id() {
    return db()->lastInsertId();
}
