<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../session.php';

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';
$input = json_decode(file_get_contents("php://input"), true);

// Helper function for response
function sendResponse($status, $message, $data = null, $code = 200) {
    http_response_code($code);
    echo json_encode([
        "status" => $status,
        "message" => $message,
        "data" => $data
    ]);
    exit;
}

// Auth guard for all non-OPTIONS requests
if (!validateApiToken()) {
    sendResponse(false, "Authentication required", null, 401);
}

$business_id = (int)($_SESSION['business_id'] ?? 0);

try {
    switch ($method) {

        // ✅ GET — Fetch settings
        case 'GET':
            if ($action === 'get' || $action === '') {
                // Ensure settings record exists for this business
                query("INSERT INTO settings (id) VALUES (?) ON DUPLICATE KEY UPDATE id=id", [$business_id]);
                
                $settings = one("SELECT * FROM settings WHERE id = ?", [$business_id]);
                if (!$settings) {
                    sendResponse(false, "Settings not found", null, 404);
                }
                
                sendResponse(true, "Settings fetched successfully", $settings);
            }
            
            else {
                sendResponse(false, "Invalid action", null, 400);
            }
            break;

        // ✅ POST/PUT — Update settings
        case 'POST':
        case 'PUT':
            if ($action === 'update' || $action === 'save') {
                $business_name = trim($input['business_name'] ?? '');
                $phone = trim($input['phone'] ?? '');
                $address = trim($input['address'] ?? '');
                $gstin = trim($input['gstin'] ?? '');
                $gst_rate = (float)($input['gst_rate'] ?? 5.0);
                $gst_applicable = (int)($input['gst_applicable'] ?? 1);

                if (empty($business_name)) {
                    sendResponse(false, "Business name is required", null, 400);
                }

                // Ensure settings record exists
                query("INSERT INTO settings (id) VALUES (?) ON DUPLICATE KEY UPDATE id=id", [$business_id]);

                query("UPDATE settings 
                          SET business_name = ?, phone = ?, address = ?, gstin = ?, gst_rate = ?, gst_applicable = ? 
                        WHERE id = ?",
                      [$business_name, $phone, $address, $gstin, $gst_rate, $gst_applicable, $business_id]);

                // Get updated settings
                $updated_settings = one("SELECT * FROM settings WHERE id = ?", [$business_id]);

                sendResponse(true, "Settings updated successfully", $updated_settings);
            }
            
            else {
                sendResponse(false, "Invalid action", null, 400);
            }
            break;

        // ❌ Invalid Method
        default:
            sendResponse(false, "Method not allowed", null, 405);
    }
    
} catch (Exception $e) {
    sendResponse(false, "Server error: " . $e->getMessage(), null, 500);
}
?>
