<?php
header("Content-Type: application/json");
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../session.php';
date_default_timezone_set('Asia/Kolkata');

function send($data) {
    echo json_encode($data);
    exit;
}

$action = $_POST['action'] ?? ($_GET['action'] ?? '');

/* ===============================================================
   REGISTER
   =============================================================== */
if ($action === "register") {

    if ($_SERVER["REQUEST_METHOD"] !== "POST") {
        send(["status" => "error", "message" => "POST method required"]);
    }

    $business_name = trim($_POST['business_name'] ?? '');
    $phone         = trim($_POST['phone'] ?? '');
    $address       = trim($_POST['address'] ?? '');
    $password      = trim($_POST['password'] ?? '');

    if ($business_name === "" || $phone === "" || $address === "" || $password === "") {
        send(["status" => "error", "message" => "All fields required"]);
    }

    $exists = one("SELECT id FROM settings WHERE phone = ?", [$phone]);
    if ($exists) {
        send(["status" => "error", "message" => "Phone number already registered"]);
    }

    $password_hash = password_hash($password, PASSWORD_BCRYPT);

    $logo_name = null;
    if (isset($_FILES['logo']) && $_FILES['logo']['error'] === 0) {

        $upload_dir = __DIR__ . "/uploads/";
        if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

        $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
        $logo_name = "logo_" . time() . "." . $ext;

        move_uploaded_file($_FILES['logo']['tmp_name'], $upload_dir . $logo_name);
    }

    query(
        "INSERT INTO settings (business_name, address, phone, password, gstin, gst_rate, gst_applicable, logo)
         VALUES (?, ?, ?, ?, '', 5.00, 1, ?)",
        [$business_name, $address, $phone, $password_hash, $logo_name]
    );

    $restaurant_id = last_id();

    query(
        "INSERT INTO subscriptions (restaurant_id, plan, start_date, expiry_date, status)
         VALUES (?, '1 month', NOW(), DATE_ADD(NOW(), INTERVAL 1 MONTH), 'active')",
        [$restaurant_id]
    );

    send([
        "status" => "success",
        "message" => "Registration successful",
        "restaurant_id" => $restaurant_id,
        "logo" => $logo_name ? "/uploads/$logo_name" : null
    ]);
}

/* ===============================================================
   LOGIN
   =============================================================== */
if ($action === "login") {

    if ($_SERVER["REQUEST_METHOD"] !== "POST") {
        send(["status" => "error", "message" => "POST method required"]);
    }

    $business_name = trim($_POST['business_name'] ?? '');
    $phone         = trim($_POST['phone'] ?? '');
    $password      = trim($_POST['password'] ?? '');

    if ($business_name === "" || $phone === "" || $password === "") {
        send(["status" => "error", "message" => "All fields required"]);
    }

    $user = one("SELECT * FROM settings WHERE business_name = ? AND phone = ?", [
        $business_name,
        $phone
    ]);

    if (!$user) {
        send(["status" => "error", "message" => "Business not found"]);
    }

    if (!password_verify($password, $user['password'])) {
        send(["status" => "error", "message" => "Invalid password"]);
    }

    $subscription = one("SELECT * FROM subscriptions WHERE restaurant_id = ? ORDER BY id DESC LIMIT 1", [
        $user['id']
    ]);

    $now = date('Y-m-d H:i:s');
    if (!$subscription || $subscription['expiry_date'] < $now || $subscription['status'] === 'expired') {
        send([
            "status" => "expired",
            "message" => "Subscription expired",
            "restaurant_id" => $user['id']
        ]);
    }

    authenticateBusiness($user['id'], $user['business_name'], 'admin');
    $token = generateApiToken($user['id'], $user['business_name'], 'admin');

    send([
        "status" => "success",
        "message" => "Login successful",
        "restaurant_id" => $user['id'],
        "business_name" => $user['business_name'],
        "token" => $token
    ]);
}

/* ===============================================================
   DEFAULT ERROR
   =============================================================== */
send(["status" => "error", "message" => "Invalid API action"]);
