<?php
require_once __DIR__ . '/db.php';

$pdo = db();

/**
 * -----------------------------------------
 * Helpers
 * -----------------------------------------
 */
function columnExists(PDO $pdo, string $table, string $column): bool {
    $stmt = $pdo->prepare("
        SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = DATABASE()
          AND TABLE_NAME = ?
          AND COLUMN_NAME = ?
    ");
    $stmt->execute([$table, $column]);
    return $stmt->fetchColumn() > 0;
}

/**
 * -----------------------------------------
 * 1. order_items table migrations
 * -----------------------------------------
 */
$orderItemsTable = 'order_items';

$orderItemMigrations = [

    'is_sent_to_kot' => "
        ALTER TABLE `$orderItemsTable`
        ADD COLUMN `is_sent_to_kot` TINYINT(1) DEFAULT 0
        AFTER `notes`
    ",

    'updated_at' => "
        ALTER TABLE `$orderItemsTable`
        ADD COLUMN `updated_at` DATETIME
        DEFAULT CURRENT_TIMESTAMP
        ON UPDATE CURRENT_TIMESTAMP
        AFTER `is_sent_to_kot`
    ",

    'last_kot_qty' => "
        ALTER TABLE `$orderItemsTable`
        ADD COLUMN `last_kot_qty` INT(11) DEFAULT 0
        AFTER `updated_at`
    "
];

echo "<b>🔧 Migrating order_items...</b><br>";

foreach ($orderItemMigrations as $column => $sql) {
    if (!columnExists($pdo, $orderItemsTable, $column)) {
        $pdo->exec($sql);
        echo "✅ Added column: <b>$column</b><br>";
    } else {
        echo "ℹ️ Column already exists: <b>$column</b><br>";
    }
}

/**
 * -----------------------------------------
 * 2. kots table creation
 * -----------------------------------------
 */
echo "<br><b>🔧 Creating kots table...</b><br>";

$pdo->exec("
CREATE TABLE IF NOT EXISTS `kots` (
    `order_id` INT(11) NOT NULL,
    `business_id` INT(11) NOT NULL,
    `kot_status` ENUM('Pending','Preparing','Ready','Updated')
        DEFAULT 'Pending',
    `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,

    PRIMARY KEY (`order_id`),
    KEY `idx_kots_business_id` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

echo "✅ kots table ready<br>";

echo "<br>🎉 <b>All migrations completed successfully</b>";
