<?php
require_once __DIR__ . '/../src/db.php';

// Step 1: Expire subscriptions whose expiry_date < NOW()
query("
    UPDATE subscriptions
    SET status = 'expired'
    WHERE expiry_date < NOW()
      AND status = 'active'
");

// Step 2: Notify restaurants expiring in 3 days
$soon = all_rows("
    SELECT restaurant_id, expiry_date
    FROM subscriptions
    WHERE DATEDIFF(expiry_date, NOW()) = 3
      AND status = 'active'
");

foreach ($soon as $row) {
    error_log("Subscription expiring soon for restaurant ID: {$row['restaurant_id']} on {$row['expiry_date']}");
}

// Step 3: Log execution
error_log("Cron renewal_check executed at: " . date('Y-m-d H:i:s'));
echo "Cron executed at: " . date('Y-m-d H:i:s');
?>
